<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Website;
use Illuminate\Support\Str;

class GenerateWebsiteTokens extends Command
{
    protected $signature = 'hipl:tokens';
    protected $description = 'Generate API tokens for websites';

    public function handle(): int
    {
        $sites = Website::all();
        foreach ($sites as $site) {
            if (!$site->api_token) {
                $site->api_token = Str::random(60);
                $site->save();
                $this->info($site->key . ' => ' . $site->api_token);
            } else {
                $this->info($site->key . ' already has token');
            }
        }
        return self::SUCCESS;
    }
}
