<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
{
    Schema::create('leads', function (Blueprint $table) {
        $table->id();

        $table->foreignId('website_id')->constrained()->cascadeOnDelete();

        // common fields (optional)
        $table->string('name')->nullable();
        $table->string('email')->nullable();
        $table->string('phone')->nullable();

        // store all other dynamic form fields here (different forms/fields)
        $table->json('payload')->nullable();

        // metadata
        $table->string('source_form')->nullable(); // e.g. Elementor form name/id
        $table->string('page_url')->nullable();
        $table->ipAddress('ip')->nullable();

        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};
