<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Website;

class WebsiteSeeder extends Seeder
{
    public function run(): void
    {
        $sites = [
            ['key' => 'hipl',        'name' => 'HIPL'],
            ['key' => 'samaratech',  'name' => 'SamaraTech'],
            ['key' => 'energybots',  'name' => 'EnergyBots'],
            ['key' => 'fieldforce',  'name' => 'FieldForce'],
            ['key' => 'hrss360',     'name' => 'HRSS360'],
            ['key' => 'askme360',    'name' => 'AskMe360'],
            ['key' => 'globylog',    'name' => 'Globylog'],
            ['key' => 'tess360',     'name' => 'Tess360'],
        ];

        foreach ($sites as $s) {
            Website::updateOrCreate(['key' => $s['key']], $s);
        }
    }
}
