@extends('layouts.admin', ['title' => 'Dashboard - HIPL CRM'])

@section('content')
<div class="d-flex align-items-center justify-content-between mb-4">
    <div>
        <h2 class="mb-0 fw-bold">Dashboard</h2>
        <div class="text-muted">Overview of leads from all websites</div>
    </div>

    <div class="d-flex gap-2">
        <a class="btn btn-outline-secondary" href="{{ route('leads.index') }}">View Leads</a>
        <a class="btn btn-success" href="{{ route('leads.export', request()->query()) }}">Export CSV</a>
    </div>
</div>

{{-- Filters --}}
<div class="card shadow-sm mb-4">
    <div class="card-body">
        <form class="row g-3" method="GET" action="{{ route('dashboard') }}">
            <div class="col-12 col-md-3">
                <label class="form-label">Website</label>
                <select name="website" class="form-select">
                    <option value="">All</option>
                    @foreach($websites as $site)
                        <option value="{{ $site->key }}" @selected(($filters['website'] ?? '') == $site->key)>
                            {{ $site->name }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Month (YYYY-MM)</label>
                <input name="month" value="{{ $filters['month'] ?? '' }}" class="form-control" placeholder="2026-01">
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" value="{{ $filters['start_date'] ?? '' }}" class="form-control">
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" value="{{ $filters['end_date'] ?? '' }}" class="form-control">
            </div>

            <div class="col-12 d-flex gap-2">
                <button class="btn btn-dark">Apply</button>
                <a class="btn btn-light" href="{{ route('dashboard') }}">Reset</a>
            </div>
        </form>
    </div>
</div>

{{-- KPI cards --}}
<div class="row g-3 mb-4">
    <div class="col-12 col-md-4">
        <div class="card shadow-sm">
            <div class="card-body">
                <div class="text-muted small">Total Leads (Filtered)</div>
                <div class="display-6 fw-bold">{{ $totalLeads }}</div>
            </div>
        </div>
    </div>

    @foreach($websites as $site)
        <div class="col-12 col-md-4 col-lg-3">
            <a href="{{ route('leads.website', ['websiteKey' => $site->key]) }}" class="text-decoration-none">
                <div class="card shadow-sm h-100">
                    <div class="card-body">
                        <div class="text-muted small">{{ $site->name }}</div>
                        <div class="h3 fw-bold mb-0">{{ $websiteCounts[$site->id] ?? 0 }}</div>
                        <div class="small text-primary mt-2">View leads →</div>
                    </div>
                </div>
            </a>
        </div>
    @endforeach
</div>

{{-- Chart placeholder (optional) --}}
<div class="card shadow-sm">
    <div class="card-body">
        <h5 class="fw-semibold mb-1">Leads Trend (optional)</h5>
        <div class="text-muted small mb-3">
            You can add Chart.js here later (month-wise leads graph).
        </div>
        <div class="bg-light border rounded p-5 text-center text-muted">
            Chart placeholder
        </div>
    </div>
</div>
@endsection
