<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $title ?? 'HIPL CRM' }}</title>

    @vite(['resources/js/app.js'])
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark border-bottom">
    <div class="container-fluid">
        <a class="navbar-brand fw-semibold" href="{{ route('dashboard') }}">HIPL CRM</a>

        <div class="d-flex align-items-center gap-2">
            <span class="text-white-50 small">{{ auth()->user()->name ?? '' }}</span>
            <form method="POST" action="{{ route('logout') }}">
                @csrf
                <button class="btn btn-outline-light btn-sm">Logout</button>
            </form>
        </div>
    </div>
</nav>

<div class="container-fluid">
    <div class="row">

        {{-- Sidebar --}}
        <aside class="col-12 col-lg-2 bg-white border-end min-vh-100 p-0">
            <div class="p-3 border-bottom">
                <div class="fw-semibold">Menu</div>
                <div class="text-muted small">Leads Management</div>
            </div>

            <div class="list-group list-group-flush">
                <a href="{{ route('dashboard') }}"
                   class="list-group-item list-group-item-action {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                    Dashboard
                </a>

                <a href="{{ route('leads.index') }}"
                   class="list-group-item list-group-item-action {{ request()->routeIs('leads.index') ? 'active' : '' }}">
                    All Leads
                </a>

                <div class="px-3 pt-3 pb-2 text-uppercase text-muted small fw-semibold">
                    Websites
                </div>

                @php
                    $sideSites = \App\Models\Website::orderBy('name')->get();
                @endphp

                @foreach($sideSites as $s)
                    <a href="{{ route('leads.website', ['websiteKey' => $s->key]) }}"
                       class="list-group-item list-group-item-action {{ request()->routeIs('leads.website') && request('websiteKey') === $s->key ? 'active' : '' }}">
                        {{ $s->name }}
                    </a>
                @endforeach
            </div>
        </aside>

        {{-- Main --}}
        <main class="col-12 col-lg-10 p-4">
            @if (session('status'))
                <div class="alert alert-success">{{ session('status') }}</div>
            @endif

            {{ $slot ?? '' }}
            @yield('content')
        </main>

    </div>
</div>

</body>
</html>
