<?php $__env->startSection('content'); ?>
<div class="d-flex align-items-center justify-content-between mb-4">
    <div>
        <h2 class="mb-0 fw-bold">Dashboard</h2>
        <div class="text-muted">Overview of leads from all websites</div>
    </div>

    <div class="d-flex gap-2">
        <a class="btn btn-outline-secondary" href="<?php echo e(route('leads.index')); ?>">View Leads</a>
        <a class="btn btn-success" href="<?php echo e(route('leads.export', request()->query())); ?>">Export CSV</a>
    </div>
</div>


<div class="card shadow-sm mb-4">
    <div class="card-body">
        <form class="row g-3" method="GET" action="<?php echo e(route('dashboard')); ?>">
            <div class="col-12 col-md-3">
                <label class="form-label">Website</label>
                <select name="website" class="form-select">
                    <option value="">All</option>
                    <?php $__currentLoopData = $websites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($site->key); ?>" <?php if(($filters['website'] ?? '') == $site->key): echo 'selected'; endif; ?>>
                            <?php echo e($site->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Month (YYYY-MM)</label>
                <input name="month" value="<?php echo e($filters['month'] ?? ''); ?>" class="form-control" placeholder="2026-01">
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">Start Date</label>
                <input type="date" name="start_date" value="<?php echo e($filters['start_date'] ?? ''); ?>" class="form-control">
            </div>

            <div class="col-12 col-md-3">
                <label class="form-label">End Date</label>
                <input type="date" name="end_date" value="<?php echo e($filters['end_date'] ?? ''); ?>" class="form-control">
            </div>

            <div class="col-12 d-flex gap-2">
                <button class="btn btn-dark">Apply</button>
                <a class="btn btn-light" href="<?php echo e(route('dashboard')); ?>">Reset</a>
            </div>
        </form>
    </div>
</div>


<div class="row g-3 mb-4">
    <div class="col-12 col-md-4">
        <div class="card shadow-sm">
            <div class="card-body">
                <div class="text-muted small">Total Leads (Filtered)</div>
                <div class="display-6 fw-bold"><?php echo e($totalLeads); ?></div>
            </div>
        </div>
    </div>

    <?php $__currentLoopData = $websites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $site): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-12 col-md-4 col-lg-3">
            <a href="<?php echo e(route('leads.website', ['websiteKey' => $site->key])); ?>" class="text-decoration-none">
                <div class="card shadow-sm h-100">
                    <div class="card-body">
                        <div class="text-muted small"><?php echo e($site->name); ?></div>
                        <div class="h3 fw-bold mb-0"><?php echo e($websiteCounts[$site->id] ?? 0); ?></div>
                        <div class="small text-primary mt-2">View leads →</div>
                    </div>
                </div>
            </a>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>


<div class="card shadow-sm">
    <div class="card-body">
        <h5 class="fw-semibold mb-1">Leads Trend (optional)</h5>
        <div class="text-muted small mb-3">
            You can add Chart.js here later (month-wise leads graph).
        </div>
        <div class="bg-light border rounded p-5 text-center text-muted">
            Chart placeholder
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', ['title' => 'Dashboard - HIPL CRM'], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Laravel_CRM\hipl-crm-new\resources\views/dashboard.blade.php ENDPATH**/ ?>