<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e($title ?? 'HIPL CRM'); ?></title>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js']); ?>
</head>
<body class="bg-light">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark border-bottom">
    <div class="container-fluid">
        <a class="navbar-brand fw-semibold" href="<?php echo e(route('dashboard')); ?>">HIPL CRM</a>

        <div class="d-flex align-items-center gap-2">
            <span class="text-white-50 small"><?php echo e(auth()->user()->name ?? ''); ?></span>
            <form method="POST" action="<?php echo e(route('logout')); ?>">
                <?php echo csrf_field(); ?>
                <button class="btn btn-outline-light btn-sm">Logout</button>
            </form>
        </div>
    </div>
</nav>

<div class="container-fluid">
    <div class="row">

        
        <aside class="col-12 col-lg-2 bg-white border-end min-vh-100 p-0">
            <div class="p-3 border-bottom">
                <div class="fw-semibold">Menu</div>
                <div class="text-muted small">Leads Management</div>
            </div>

            <div class="list-group list-group-flush">
                <a href="<?php echo e(route('dashboard')); ?>"
                   class="list-group-item list-group-item-action <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                    Dashboard
                </a>

                <a href="<?php echo e(route('leads.index')); ?>"
                   class="list-group-item list-group-item-action <?php echo e(request()->routeIs('leads.index') ? 'active' : ''); ?>">
                    All Leads
                </a>

                <div class="px-3 pt-3 pb-2 text-uppercase text-muted small fw-semibold">
                    Websites
                </div>

                <?php
                    $sideSites = \App\Models\Website::orderBy('name')->get();
                ?>

                <?php $__currentLoopData = $sideSites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('leads.website', ['websiteKey' => $s->key])); ?>"
                       class="list-group-item list-group-item-action <?php echo e(request()->routeIs('leads.website') && request('websiteKey') === $s->key ? 'active' : ''); ?>">
                        <?php echo e($s->name); ?>

                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </aside>

        
        <main class="col-12 col-lg-10 p-4">
            <?php if(session('status')): ?>
                <div class="alert alert-success"><?php echo e(session('status')); ?></div>
            <?php endif; ?>

            <?php echo e($slot ?? ''); ?>

            <?php echo $__env->yieldContent('content'); ?>
        </main>

    </div>
</div>

</body>
</html>
<?php /**PATH D:\Laravel_CRM\hipl-crm-new\resources\views/layouts/admin.blade.php ENDPATH**/ ?>